# 画面設計書 8-Add/Edit Rule

## 概要

本ドキュメントは、QUASTO（Oracle APEXアプリケーション）のAdd/Edit Rule画面（Page ID: 7）の設計書である。Add/Edit Rule画面は、品質チェックルールの新規追加・編集・削除を行うモーダルダイアログ画面である。

### 本画面の処理概要

Add/Edit Rule画面は、QUASTOの品質チェックルールを作成・編集するためのフォーム画面である。ルールの基本情報（番号、名前、クライアント）、検証対象（カテゴリ、レイヤー、オブジェクトタイプ）、検証SQLステートメント、エラー設定（エラーレベル、エラーメッセージ）などを設定できる。

**業務上の目的・背景**：品質チェックルールはQUASTOの核となる機能であり、各ルールは特定のSQLステートメントを使用してデータベースオブジェクトの品質を検証する。本画面は、ルールの詳細設定を行うインターフェースを提供し、組織の品質基準に合わせたカスタムルールの作成を可能にする。

**画面へのアクセス方法**：Rules画面から「Add Rule」ボタンまたはルール行の編集アイコンをクリックしてモーダルダイアログとして開く。

**主要な操作・処理内容**：
1. 新規ルールの追加（Createボタン）
2. 既存ルールの編集・保存（Saveボタン）
3. ルールの削除（Deleteボタン、テスト結果がない場合のみ）
4. ダイアログを閉じる（Closeボタン）

**画面遷移**：
- 遷移元：Rules画面（Add Ruleボタンまたは編集リンク）
- 遷移先：なし（モーダルダイアログのためClose/Save/Create/Deleteで親画面に戻る）

**権限による表示制御**：Protection Level「C」（認証必須）が設定されており、ログイン済みユーザーのみアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 10 | ルール管理 | 主機能 | ルールの追加・編集・削除 |

## 画面種別

モーダルダイアログ（フォーム・登録/編集系）- ストレッチダイアログ

## URL/ルーティング

- Page ID: 7
- エイリアス: ADD-EDIT-RULE
- URL例: `f?p=141:7:SESSION_ID::NO::P7_QARU_ID:`（新規）または`f?p=141:7:SESSION_ID::NO::P7_QARU_ID:123`（編集）

## 入出力項目

### 入力項目

#### Left Content（左側コンテンツ領域）

| 項目名 | 項目ID | タイプ | 必須 | 説明 |
|--------|--------|--------|------|------|
| Rule Number | P7_QARU_RULE_NUMBER | テキストフィールド | Yes | ルール番号（編集時は読み取り専用） |
| Client Name | P7_QARU_CLIENT_NAME | テキストフィールド | Yes | クライアント/プロジェクト名（編集時は読み取り専用） |
| Name | P7_QARU_NAME | テキストフィールド | Yes | ルール名（最大400文字） |
| Category | P7_QARU_CATEGORY | ラジオボタン | Yes | ルールカテゴリ（RULE_CATEGORIES_LOV） |
| Layer | P7_QARU_LAYER | ラジオボタン | Yes | レイヤー（RULE_LAYERS_LOV） |
| Error Level | P7_QARU_ERROR_LEVEL | ラジオボタン | Yes | エラーレベル（RULE_ERROR_LEVELS_LOV） |
| Active | P7_QARU_IS_ACTIVE | Yes/No | Yes | アクティブ状態（デフォルト: Yes） |
| Comment | P7_QARU_COMMENT | テキストフィールド | No | コメント（最大4000文字） |
| Error Message | P7_QARU_ERROR_MESSAGE | テキストフィールド | Yes | エラーメッセージ（最大4000文字） |
| Object Types | P7_QARU_OBJECT_TYPES | テキストエリア | Yes | 対象オブジェクトタイプ（コロン区切り） |
| Exclude Objects | P7_QARU_EXCLUDE_OBJECTS | テキストエリア | No | 除外オブジェクト（コロン区切り） |

#### Right Content（右側コンテンツ領域）

| 項目名 | 項目ID | タイプ | 必須 | 説明 |
|--------|--------|--------|------|------|
| SQL Statement | P7_QARU_SQL | テキストエリア（CLOB） | Yes | 検証用SQLステートメント（45行表示） |

### 隠し項目

| 項目名 | 項目ID | タイプ | 説明 |
|--------|--------|--------|------|
| QARU ID | P7_QARU_ID | Hidden | ルールID（プライマリキー） |

### ボタン

| ボタン名 | 項目ID | 配置位置 | アクション | 条件 | スタイル |
|---------|--------|----------|----------|------|--------|
| Close | CLOSE | CLOSE | ダイアログを閉じる | なし | デフォルト |
| Delete | DELETE | DELETE | ルールを削除 | P7_QARU_ID IS NOT NULL | Danger（赤） |
| Save | SAVE | NEXT | ルールを保存 | P7_QARU_ID IS NOT NULL | Hot + アイコン |
| Create | CREATE | NEXT | ルールを新規作成 | P7_QARU_ID IS NULL | Hot + アイコン |

## イベント仕様

### 1-Close Dialog

**トリガー**: CLOSEボタンクリック

**処理フロー**:
1. ダイアログを閉じる（NATIVE_DIALOG_CLOSE）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページロード | QA_RULES_P0007_V | SELECT | P7_QARU_IDに基づいてルール情報を取得 |
| Create | QA_RULES | INSERT | 新規ルールを追加 |
| Save | QA_RULES | UPDATE | 既存ルールを更新 |
| Delete | QA_RULES | DELETE | ルールを削除（テスト結果がない場合のみ） |

### プロセス別詳細

#### Save Form Process

**実行タイミング**: Create/Save/Deleteボタン押下後（After Submit）

**処理内容**:
- NATIVE_FORM_DMLを使用してQA_RULES_P0007_Vに対してINSERT/UPDATE/DELETE操作を実行
- 成功メッセージ: 「Changes saved.」

#### Close Dialog

**実行タイミング**: フォーム保存後

**処理内容**:
- ダイアログを閉じる（NATIVE_CLOSE_WINDOW）

### バリデーション

#### 1-Validate if rule can be deleted

**トリガー**: DELETEボタン押下時

**PL/SQL条件**:
```sql
NOT qa_unit_tests_pkg.f_has_rule_test_results(
  pi_qaru_rule_number => :P7_QARU_RULE_NUMBER,
  pi_qaru_client_name => :P7_QARU_CLIENT_NAME
)
```

**エラーメッセージ**: The Rule has saved test results and therefore cannot be deleted. Please set it to "Inactive" instead.

#### 2-Validate if Rule already exists

**トリガー**: CREATEボタン押下時

**PL/SQL条件**: 同一のルール番号・クライアント名の組み合わせが存在しないことを確認

**エラーメッセージ**: Rulenumber already exists for this client.

#### 3-Validate if Name already exists

**トリガー**: CREATEボタン押下時

**PL/SQL条件**: 同一のルール名・クライアント名の組み合わせが存在しないことを確認

**エラーメッセージ**: Rulename already exists for this client.

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| - | 成功 | 保存成功時 | Changes saved. |
| - | 確認 | 削除確認時 | Do you really want to delete this rule? |
| - | エラー | 削除不可時 | The Rule has saved test results and therefore cannot be deleted. Please set it to "Inactive" instead. |
| - | エラー | ルール番号重複時 | Rulenumber already exists for this client. |
| - | エラー | ルール名重複時 | Rulename already exists for this client. |

## 例外処理

| 例外状態 | 表示・動作 |
|---------|----------|
| ルールにテスト結果がある状態での削除試行 | バリデーションエラーを表示、「Inactive」に設定することを推奨 |
| ルール番号・クライアント名の重複 | バリデーションエラーを表示（新規作成時） |
| ルール名・クライアント名の重複 | バリデーションエラーを表示（新規作成時） |

## 備考

- 本画面はストレッチモーダルダイアログとして表示（ui-dialog--stretch）
- フォームは2列レイアウト（Left Content / Right Content）
- Rule NumberとClient Nameは編集時は読み取り専用（P7_QARU_ID IS NOT NULL条件）
- Object TypesとExclude Objectsはコロン（:）で区切って複数値を入力
- Object Typesにはクイックピック機能あり（PROCESS、TABLE、VIEW、PACKAGE、PACKAGE BODY、ITEM）
- 削除ボタンにはwarningスタイルの確認ダイアログを表示
- SQL Statementは45行表示のテキストエリア
- データソースはQA_RULES_P0007_Vビュー（QA_RULESテーブルのラッパー）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 画面定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page_00007.sql | `src/apex/f141/application/pages/page_00007.sql` | モーダルダイアログとフォームの構成 |

**主要処理フロー**:
1. **行14-24**: `wwv_flow_imp_page.create_page`でストレッチモーダルダイアログ設定
2. **行25-48**: Add/Edit Ruleリージョンの定義
3. **行36-48**: Add/Edit Rule Formリージョン（NATIVEフォーム）の定義
4. **行49-74**: Left Content / Right Contentリージョンの定義
5. **行75-151**: ボタン定義（CLOSE、DELETE、SAVE、CREATE）
6. **行152-445**: フォームアイテム定義（P7_QARU_*）
7. **行446-522**: バリデーション定義
8. **行523-575**: プロセス定義（Save Form、Close Dialog、Initialize form）

#### Step 2: PL/SQLパッケージを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | f_has_rule_test_resultsの実装 |

**主要処理フロー**:
- **行1388-1433**: `f_has_rule_test_results`でルールにテスト結果があるか確認

### プログラム呼び出し階層図

```
Add/Edit Rule Page (Page 7)
    |
    +-- [Page Load - Before Header]
    |       |
    |       +-- Initialize form Edit Rule (NATIVE_FORM_INIT)
    |               |
    |               +-- SELECT FROM QA_RULES_P0007_V
    |                   WHERE QARU_ID = :P7_QARU_ID
    |
    +-- [Button: CREATE - Submit]
    |       |
    |       +-- Validation: Rule already exists?
    |       +-- Validation: Name already exists?
    |       |
    |       +-- Process: Save Form Process (INSERT)
    |       +-- Process: Close Dialog
    |
    +-- [Button: SAVE - Submit]
    |       |
    |       +-- Process: Save Form Process (UPDATE)
    |       +-- Process: Close Dialog
    |
    +-- [Button: DELETE - Submit]
    |       |
    |       +-- Confirmation Dialog
    |       +-- Validation: Can rule be deleted?
    |               |
    |               +-- qa_unit_tests_pkg.f_has_rule_test_results
    |       |
    |       +-- Process: Save Form Process (DELETE)
    |       +-- Process: Close Dialog
    |
    +-- [Button: CLOSE]
            |
            +-- Dynamic Action: Close Dialog
```

### データフロー図

```
[入力]                      [処理]                           [出力]

Rules画面                   Page 7 Load                      フォーム表示
(P7_QARU_ID)        ───>   Initialize form            ───> (各P7_*項目)
                                  |
                                  v
                           QA_RULES_P0007_V
                           (SELECT)

フォーム入力               Save Form Process                 QA_RULES
(各P7_*項目)        ───>   (INSERT/UPDATE/DELETE)     ───> (更新)
                                  |
                                  v
                           バリデーション
                           (重複チェック、削除可能チェック)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00007.sql | `src/apex/f141/application/pages/page_00007.sql` | ソース | Add/Edit Rule画面定義 |
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | f_has_rule_test_results実装 |
| page_00006.sql | `src/apex/f141/application/pages/page_00006.sql` | ソース | Rules画面（呼び出し元） |
